<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class SoreMainMenuRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'title_en'=>'required',
            'title_mr'=>'required',
			'headline_en'=>'required',
			'headline_mr'=>'required',
			'image_en' => 'nullable|mimes:jpg,jpeg,png|max:2048',
			'image_mr' => 'nullable|mimes:jpg,jpeg,png|max:2048',
        ];
    }
	
	public function messages(): array
    {
        return [
            'title_en.required'     => 'Please enter your title.',
            'title_mr.required'     => 'Please enter your title.',
            'headline_en.string'       => 'The Headline must be a valid string.',
            'headline_mr.string'       => 'The Headline must be a valid string.',
            'image_en.image' => 'The file must be an image_en.',
            'image_mr.image' => 'The file must be an image_mr.',
			'image_en.mimes' => 'Allowed image_en types are: jpeg, png, jpg, gif, svg.',
			'image_mr.mimes' => 'Allowed image_mr types are: jpeg, png, jpg, gif, svg.',
			'image_en.max'   => 'The image_en size must not exceed 2MB.',            
			'image_mr.max'   => 'The image_mr size must not exceed 2MB.',            
        ];
    }
	
}
