<?php

namespace App\Http\Controllers;

use App\Http\Requests\StoreNominationDocsRequest;
use App\Http\Requests\UpdateNominationDocsRequest;
use App\Models\NominationDocs;
use App\Models\GeneralElection;
use Illuminate\Http\Request;
use App;
use Auth;

class NominationDocsController extends Controller
{
     /**
     * Display a listing of the resource.
     */
    public function index(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
        $nomination_docs = NominationDocs::all();
		
		//echo "<pre>";print_r($nomination_docs);echo "</pre>";die();
		
        return view('nomination_docs.index', compact(['nomination_docs','currentLocale','general_election']));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
        return view('nomination_docs.create',compact('general_election','currentLocale'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreNominationDocsRequest  $request,GeneralElection $general_election)
    {
        $data = $request->validated();
        
		$currentLocale = App::getLocale();
		 
		//echo "<pre>";print_r($currentLocale);echo "</pre>";die();
		
		$path_en = null;

		if ($request->hasFile('file_en')) {
			$file_en = $request->file('file_en');

			// Optional: Custom filename
			$filename = time() . '_' . $file_en->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_en = $file_en->storeAs('uploads', $filename, 'public');
		}
		
		$extension_en = pathinfo($path_en, PATHINFO_EXTENSION);
		
		$path_mr = null;

		if ($request->hasFile('file_mr')) {
			$file_mr = $request->file('file_mr');
			
			// Optional: Custom filename
			$filename = time() . '_' . $file_mr->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_mr = $file_mr->storeAs('uploads', $filename, 'public');
		}
		
		$extension_mr = pathinfo($path_mr, PATHINFO_EXTENSION);
		
		NominationDocs::create([
			'returning_officer_en' => $data['returning_officer_en'],
			'returning_officer_mr' => $data['returning_officer_mr'],
			'file_en' => $path_en,
			'file_mr' => $path_mr,
			'file_ext_en' => $extension_en,
			'file_ext_mr' => $extension_mr,
			'general_election_id' => $general_election->id
		]);	
		
        return redirect()->route('nomination_docs.index',$general_election);
    }

    /**
     * Display the specified resource.
     */
    public function show(NominationDocs $NominationDocs)
    {
        return view('nomination_docs.edit', compact('nomination_doc'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(NominationDocs $nomination_doc)
    {
        return view('nomination_docs.edit', compact('nomination_doc'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateNominationDocsRequest $request, NominationDocs $nomination_doc)
    {
        $data = $request->validated();		 
		
		
		//echo "<pre>";print_r($data);echo "</pre>";die();
		
		$path_en = null;

		if ($request->hasFile('file_en')) {
			$file_en = $request->file('file_en');			
			// Optional: Custom filename
			$filename = time() . '_' . $file_en->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_en = $file_en->storeAs('uploads', $filename, 'public');
			$data['file_en']=$path_en;
			$data['file_ext_en']=pathinfo($path_en, PATHINFO_EXTENSION);	
		}
		
		$path_mr = null;

		if ($request->hasFile('file_mr')) {
			$file_mr = $request->file('file_mr');			

			// Optional: Custom filename
			$filename = time() . '_' . $file_mr->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_mr = $file_mr->storeAs('uploads', $filename, 'public');
			$data['file_mr']=$path_mr;
			$data['file_ext_mr']=pathinfo($path_mr, PATHINFO_EXTENSION);
		}
		
		
		
		
		
        $nomination_doc->update($data);
		
        return redirect()->route('nomination_docs.index',$nomination_doc->general_election);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(NominationDocs $nomination_doc)
    {
        $nomination_doc->delete();
        return redirect()->route('nomination_docs.index',$nomination_doc->general_election);
    }
}
