<?php

namespace App\Http\Controllers;

use App\Models\MuncipalCorporation;
use App\Models\GeneralElection;
use Illuminate\Http\Request;
use App\Http\Requests\StoreMuncipalCorporationRequest;
use App\Http\Requests\UpdateMuncipalCorporationRequest;
use App;
use Auth;

class MuncipalCorporationController extends Controller
{
     /**
     * Display a listing of the resource.
     */
    public function index(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
        $muncipal_corporations = MuncipalCorporation::all();
        return view('muncipal_corporations.index', compact(['muncipal_corporations','currentLocale','general_election']));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create(GeneralElection $general_election)
    {
		$currentLocale = App::getLocale();
        return view('muncipal_corporations.create', compact(['currentLocale','general_election']));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreMuncipalCorporationRequest  $request,GeneralElection $general_election)
    {
        $data = $request->validated();
        
		$currentLocale = App::getLocale();
		 
		//echo "<pre>";print_r($currentLocale);echo "</pre>";die();
		
		$path_en = null;

		if ($request->hasFile('file_en')) {
			$file_en = $request->file('file_en');		
			// Optional: Custom filename
			$filename = time() . '_' . $file_en->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_en = $file_en->storeAs('uploads', $filename, 'public');
		}
		
		$extension_en = pathinfo($path_en, PATHINFO_EXTENSION);
		$path_mr = null;

		if ($request->hasFile('file_mr')) {
			$file_mr = $request->file('file_mr');		
			// Optional: Custom filename
			$filename = time() . '_' . $file_mr->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_mr = $file_mr->storeAs('uploads', $filename, 'public');
		}
		
		$extension_mr = pathinfo($path_mr, PATHINFO_EXTENSION);
		
		MuncipalCorporation::create([
			'title_en' => $data['title_en'],
			'title_mr' => $data['title_mr'],
			'file_en' => $path_en,
			'file_mr' => $path_mr,
			'file_ext_en' => $extension_en,
			'file_ext_mr' => $extension_mr,
			'general_election_id' =>$general_election->id
		]);	
		
        return redirect()->route('muncipal_corporations.index',$general_election);
    }

    /**
     * Display the specified resource.
     */
    public function show(MuncipalCorporation $muncipal_corporation)
    {
        return view('muncipal_corporations.edit', compact('muncipal_corporation'));
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(MuncipalCorporation $muncipal_corporation)
    {
		//echo "<pre>";print_r($muncipal_corporation);echo "</pre>";die();
        return view('muncipal_corporations.edit', compact('muncipal_corporation'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateMuncipalCorporationRequest $request, MuncipalCorporation $muncipal_corporation)
    {
        $data = $request->validated();		 
		
		
		//echo "<pre>";print_r($data);echo "</pre>";die();
		
		$path_en = null;

		if ($request->hasFile('file_en')) {
			$file_en = $request->file('file_en');			
			// Optional: Custom filename
			$filename = time() . '_' . $file_en->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_en = $file_en->storeAs('uploads', $filename, 'public');
			$data['file_en']=$path_en;
			$data['file_ext_en']=pathinfo($path_en, PATHINFO_EXTENSION);		
		}
		
		$path_mr = null;

		if ($request->hasFile('file_mr')) {
			$file_mr = $request->file('file_mr');	

			// Optional: Custom filename
			$filename = time() . '_' . $file_mr->getClientOriginalName();

			// Save in 'storage/app/public/uploads'
			$path_mr = $file_mr->storeAs('uploads', $filename, 'public');
			$data['file_mr']=$path_mr;
			$data['file_ext_mr']= pathinfo($path_mr, PATHINFO_EXTENSION);
		}		
		
        $muncipal_corporation->update($data);
		
        return redirect()->route('muncipal_corporations.index',$muncipal_corporation->general_election);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(MuncipalCorporation $muncipal_corporation)
    {
        $muncipal_corporation->delete();
        return redirect()->route('muncipal_corporations.index',$muncipal_corporation->general_election);
    }
}
